<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/functions.php';
if (empty($_SESSION['admin'])){ header('Location: login.php'); exit; }
if (!isset($_POST['name']) || !isset($_POST['category_id'])){ header('Location: products.php'); exit; }
$data = load_data();
$name = trim($_POST['name']);
$desc = trim($_POST['description'] ?? '');
$category_id = (int)$_POST['category_id'];
$price = isset($_POST['price']) ? (int)$_POST['price'] : 0;
$link = trim($_POST['link'] ?? '');
$stock = isset($_POST['stock']) ? (int)$_POST['stock'] : 0;
$id = isset($_POST['id']) && $_POST['id'] !== '' ? (int)$_POST['id'] : null;
$image_path = null;
$video_path = null;
if (isset($_FILES['image']) && $_FILES['image']['error'] == UPLOAD_ERR_OK){
    $uploaded = upload_media($_FILES['image']);
    if ($uploaded) $image_path = $uploaded;
}
if (isset($_FILES['video']) && $_FILES['video']['error'] == UPLOAD_ERR_OK){
    $uploaded = upload_media($_FILES['video']);
    if ($uploaded) $video_path = $uploaded;
}
if ($id){
    foreach($data['products'] as &$p) if ($p['id'] == $id){
        $p['name'] = $name;
        $p['description'] = $desc;
        $p['category_id'] = $category_id;
        $p['price'] = $price;
        $p['link'] = $link;
        $p['stock'] = $stock;
        if ($image_path){ if (!empty($p['image'])) delete_file_path($p['image']); $p['image'] = $image_path; }
        if ($video_path){ if (!empty($p['video'])) delete_file_path($p['video']); $p['video'] = $video_path; }
    }
} else {
    $nid = next_id($data['products']);
    $data['products'][] = [
        'id'=>$nid,
        'name'=>$name,
        'description'=>$desc,
        'category_id'=>$category_id,
        'image'=>($image_path?: 'https://via.placeholder.com/800x600?text=' . urlencode($name)),
        'video'=>$video_path?:'',
        'price'=>$price,
        'link'=>$link,
        'stock'=>$stock
    ];
}
save_data($data);
header('Location: products.php'); exit;
?>